﻿var libraryBrowser = {
    container: null,
    page: null,
    itemInPreview: null,
    questionnaireId: 0,

    selectedItem: 0,
    selectedPublicSource: false,

    isThemeBrowser: false,
    themeRowNbItems: 3,
    themeQuestionId: 0,
    themeBlockId: 0,
    reloadThemeBrowser: false,

    activeSection: "",
    activeContext: false,

    initLibraryBrowser: function(container, page, questionnaireId) {
        libraryBrowser.container = container;
        libraryBrowser.page = page;
        libraryBrowser.questionnaireId = questionnaireId;
        libraryBrowser.isThemeBrowser = $(".templateBrowser", container).length > 0;

        if (libraryBrowser.isThemeBrowser) {
            libraryBrowser.themeRowNbItems = ($(window).width() <= 1300) ? 3 
                                                : ($(window).width() <= 1600) ? 4 : 5;

            var previewQuestion = $(".previewZoneContainer .itemContainer:visible:first", container);

            if (previewQuestion.length > 0) { 
                libraryBrowser.themeQuestionId = previewQuestion.attr("id").replace("Question", "");
                libraryBrowser.themeBlockId = previewQuestion.attr("data-block");
            }
        }
    },

    changeLibraryNavigation: function (library, useSiblings, changeIcons) {
        libraryBrowser.clearFoundItems(library);
        libraryBrowser.resetActiveItems(library);

        var sections = (useSiblings) ? library.siblings(".library") : library;
        libraryBrowser.activeSection = $(".v-sectionHeader", library).data("section");

        $(".v-search :text", library.parent(".v-libraryBrowser")).val("");

        $(".v-structurOptions", sections).hide();
        $(".v-search", sections).hide();
        $(".v-folderList", sections).hide();
        $(".pager", sections).hide();

        if (changeIcons) {
            $(".right-arrow-white:hidden", sections).show();
            $(".down-arrow-white:visible", sections).hide();
        }
    },

    resetBrowser: function(library) {
        var root = library.closest(".v-libraryBrowser");

        $("ul.v-folderList.fixed", library).removeClass("fixed");
        $(".found-items-list .question", library).detach();
        $(".found-items-list", library).hide();

        var visibleItems = $("ul.v-folderList li.h-folderItem:visible", library);
    
        $(".active", root).removeClass("active");
        $(".pager", library).hide();
        $(".v-search", library).hide();

        visibleItems.slideUp(200, "easeOutExpo");
        root.slideDown(200, "easeOutExpo");

        $("div.lheader .find", library).val("Search");
        $(".list .breadCrumb", library).hide();
    },

    loadFolderContent: function(folder, callback) {
        var list = folder.siblings("ul.v-folderList");
        var id = folder.attr("data-id");

        if (list.html() != "" || typeof id == "undefined") {
            if (callback)
                callback();
        }
        else {       
            var section = folder.attr("data-section");
        
            a4.callServerMethod(libraryBrowser.page + "GetLibraryBrowserContentPanel", { surveyId: libraryBrowser.questionnaireId, section: section, id: id }, 
                function (result) {
                    list.html(result);

                    if (callback)
                        callback();
                },
                function () {}
            );
        }
    },

    loadTemplateScrollable: function(folder) {    
        var section = folder.attr("data-section");
        var container = $(".themesContainer", folder.closest(".templateBrowser"));
        var previewZone = $(".preview", container);
        var categoryId = folder.attr("data-id");
            
        if (typeof categoryId != "undefined")
        {
            var args = {
                questionnaireId: libraryBrowser.questionnaireId,
                blockId: libraryBrowser.themeBlockId,
                questionId: libraryBrowser.themeQuestionId,
                nbItems: libraryBrowser.themeRowNbItems,
                section: section,
                categoryId: categoryId
            };
    
            previewZone.html($(".h-waitingIcon:first", container).clone().show());

            a4.callServerMethod(libraryBrowser.page + "GetLibraryBrowserTemplates", args, 
                function (result) {       
                    previewZone.html(result);      
                    libraryBrowser.initTemplatesScrollable(container);
                },
		        function () {  }
            );
        }
    },

    initTemplatesScrollable: function(container) {
        var previewZone = $(".preview", container);
        $(".scrollable:visible", previewZone).css("width", $(".scrollable.hidden", libraryBrowser.container).css("width"));
        $(".scrollable", previewZone).scrollable();
    },

    addPager: function (list) {
        var library = list.closest(".v-libraryBrowser");
        var items = list.children("li.h-folderItem");

        $(".pager", library).hide();

        if (items.length > 5) {
            list.addClass("fixed");

            if ($(".v-search", list).length > 0) {
                $(".v-search", list).after($(".pager.up", library));
            }
            else {
                list.before($(".pager.up", library));
            }

            list.after($(".pager.down", library));
            $(".pager", library).show();
        }

        items.slice(0, 5).filter(":hidden").slideDown(200, "easeOutExpo");
        items.slice(5).filter(":visible").slideUp(200, "easeOutExpo");
    },

    expandFolder: function(folder){
        var list = folder.siblings("ul.v-folderList:not(.found-items-list)");
        var items = $("li.h-folderItem", list);
        var library = folder.closest(".library");
        var parent = folder.closest(".v-folderParent");

        $(".v-search", library).show();

        if (libraryBrowser.activeSection != "Questionnaires")
            libraryBrowser.clearFoundItems(library);
        else
        {
            var itemId = folder.data("id") || null;
            var itemSection = folder.data("section") || null;

            if (itemId && (itemSection == "Questionnaires" || itemSection == "Blocks"))
                libraryBrowser.activeContext = true;
        }

        $("ul.v-folderList.fixed", library).removeClass("fixed");    
        $(".active", list).removeClass("active", 100);
        folder.addClass("active", 100);

        // Hide elements at the current level
        parent.siblings(".h-folderItem:visible").slideUp(200, "easeOutExpo");

        // Hide elements in sub folders
        $(".v-folderParent .h-folderItem", parent).slideUp(200, "easeOutExpo");

        // Show list items and add paging
        list.slideDown(200, "easeOutExpo");
        libraryBrowser.addPager(list);

        // If browser linked to questionnaire
        if (questionnaireEditor) {
            if (list.hasClass("questions-list")) {
                questionnaireEditor.setBlockItemsDraggable($(".h-questionnaireItem", list));
            }
            else if (list.hasClass("blocks-list")) {
                questionnaireEditor.setBlocksDraggable($(".h-folderItem", list));
            }
        }
    },

    selectQuestions: function(folder) {
        var list = folder.siblings("ul.v-folderList");

        $(".question .item", list).each(function () {
            libraryBrowser.selectQuestion($(this));
        });
    },

    selectQuestion: function(item) {
        var library = item.closest(".library");
        var clone = item.clone();
        item.parent().append(clone);
        $(".imgAddItem", clone).toggleClass("imgAddItem imgDeleteItem2");
        $(".breadCrumb", clone).show();
        $(".selected", library).append(clone);
        $(".selectedQuestions", library).show();
    },

    loadQuestionPreview: function(item) {
        var library = item.closest(".library");
        var preview = $(".preview", library);
        var questionId = item.attr("data-id");
        var questionType = item.attr("data-questiontype");
        var section = item.attr("data-section");

        if (questionId != preview.attr("data-id") || section != preview.attr("data-section")) {
            $("body").addClass("wait");
            $(".h-waitingIcon", library).show();
            libraryBrowser.itemInPreview = item;
            $(".addPreviewQuestion", library).show();

            a4.callServerMethod(libraryBrowser.page + "GetQuestionBrowserPreview", { questionnaireId: libraryBrowser.questionnaireId, questionId: questionId, section: section }, 
                function (result) {
                    $(".h-waitingIcon", library).hide();
                    $("body").removeClass("wait");
                    preview.html(result);
                    preview.attr("data-id", questionId);
                    preview.attr("data-section", section);
                },
		        function () { 
		            $("body").removeClass("wait"); 
		        }
            );
        }
    },

    searchItems: function(element) {
        var library = element.closest(".library");
        var question = library.find(".h-find").val().trim();
        var questionnaire = "";
        var isQuestionnairesSearch = false;

        if (libraryBrowser.activeSection == "Questionnaires")
        {
            if (library.find(".h-findSurvey"))
                questionnaire = library.find(".h-findSurvey").val().trim();

            isQuestionnairesSearch = question == "" && questionnaire != "";
        }

        // Execute search
        if (libraryBrowser.isThemeBrowser) {
            libraryBrowser.executeTemplateBrowserSearch(library, question);
        }
        else if (isQuestionnairesSearch) {
            libraryBrowser.searchQuestionnaires(library, questionnaire);
        }
        else {
            libraryBrowser.executeQuestionBrowserSearch(library, question, questionnaire);
        }
    },

    executeQuestionBrowserSearch: function (library, textToSearch, questionnaire) {
        var lastActive = $("div.active:last", library);
        var section = "";
        var id = 0;

        if (lastActive.length == 0) {
            $(".items", library).slideUp(200, "easeOutExpo");
        }
        else {
            if (lastActive.attr("data-section"))
                section = lastActive.attr("data-section");

            if (lastActive.attr("data-id"))
                id = lastActive.attr("data-id");

            lastActive.siblings("ul:not(.found-items-list)").slideUp(200, "easeOutExpo");
        }

        var data = {
            surveyId: libraryBrowser.questionnaireId,
            text: textToSearch,
            section: section,
            id: id,
            questionnaire: questionnaire
        };

        a4.callServerMethod(libraryBrowser.page + "SearchBrowserItems", data,
            function (result) {
                var browser = library.closest(".v-libraryBrowser");
                var foundItemsList = $(".found-items-list", browser);

                if (id != 0 && libraryBrowser.activeSection == "Questionnaires")
                {
                    if (section == "Blocks") {
                        foundItemsList = lastActive.siblings(".questions-list");
                    }
                    else {
                        foundItemsList = lastActive.siblings(".blocks-list");
                    }
                }

                $("ul.v-folderList.fixed", library).removeClass("fixed");

                foundItemsList.html(result);

                // If found items list not in currently library then move library
                if ($(".found-items-list", library).length == 0) {
                    $("ul.v-folderList:first", library).after(foundItemsList);
                }

                // If found items set draggable
                if ($("#NoItemsFound:visible", foundItemsList).length == 0) {
                    questionnaireEditor.setBlockItemsDraggable($(".h-questionnaireItem", foundItemsList));
                }

                if (section == "" || section == "Questionnaires" || id == 0) {
                    $(".breadCrumb", foundItemsList).css("display", "inline-block");
                }

                foundItemsList.show();
                foundItemsList.slideDown(200, "easeOutExpo");
                libraryBrowser.addPager(foundItemsList);
            },
	        function () { }
        );
    },

    executeTemplateBrowserSearch: function(library, text) {
        var section = "";
        var lastActive = $("div.active:last", library);

        if (lastActive.length > 0 && lastActive.attr("data-section")) {
            section = lastActive.attr("data-section");
        }

        var previewZone = $(".preview", library);
        previewZone.html($(".h-waitingIcon", library).clone().show());
    
        var data = {
            questionnaireId: libraryBrowser.questionnaireId,
            text: text,
            section: section,
            blockId: libraryBrowser.themeBlockId,
            questionId: libraryBrowser.themeQuestionId,
            nbItems: libraryBrowser.themeRowNbItems
        }

        a4.callServerMethod(libraryBrowser.page + "SearchBrowserItems", data, function (result) {
            previewZone.html(result);      
            $(".scrollable:visible", previewZone).css("width", $(".scrollable.hidden", libraryBrowser.container).css("width"));
            $(".scrollable", previewZone).scrollable();
        },
	    function () {});
    },

    clearFoundItems: function(library){
        if ($(".found-items-list", library).is(":visible")) {            
            $(".found-items-list", library).hide();    
            $(".pager", library).hide();
    
            $("ul.fixed", library).removeClass("fixed");
        }

        if ($("#NoItemsFound", library).is(":visible")) {
            $("#NoItemsFound", library).closest("ul").hide();
        }
    },

    resetActiveItems: function (library) {
        $(".v-folderList .h-folderItem .h-folder.active", library).removeClass("active");
        libraryBrowser.activeSurveyContext = false;
    },

    setImportQuestionsEvents: function() {
        libraryBrowser.container.on("click", ".v-libraryBrowser .library div.home", function (event) {
            var library = $(this).closest(".library");
            libraryBrowser.resetBrowser(library);
        });
    
        libraryBrowser.container.on("click", ".v-libraryBrowser .library div.exit", function (event) {
            $(".v-libraryBrowser", libraryBrowser.container).hide("slide", {}, 700);
        });

        // click on folder
        libraryBrowser.container.on("click", ".v-libraryBrowser .library li .h-folder, .v-libraryBrowser .library .h-headerItem", function (event) {
            var isFolder = $(this).hasClass("h-folder");
            var folder = isFolder ? $(this) : $(this).closest(".h-folder");
            libraryBrowser.selectedPublicSource = (folder.attr("data-section") == "PublicLibrary");       

            if (folder.attr("data-id") != undefined && libraryBrowser.isThemeBrowser) {            
                libraryBrowser.loadTemplateScrollable(folder);
            }
            else {
                libraryBrowser.loadFolderContent(folder, function () { libraryBrowser.expandFolder(folder); });
            }
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library .pager.up", function (event) {    
            var list = $(this).next("ul.v-folderList");
            var firstVisible = list.children("li:visible:first");
            var prev = firstVisible.prevAll("li:hidden").slice(0, 5);

            if (prev.length < 5) {
                var tempList = list.children("li").slice(-5 + prev.length);
                prev = $.merge(tempList, prev);
                prev = tempList;
                prev.prependTo(list);
            }

            var next = prev.last().nextAll("li:visible");
            prev.slideDown(200, "easeOutExpo");
            next.slideUp(200, "easeOutExpo");
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library .pager.down", function (event) {    
            var list = $(this).prev("ul.v-folderList");
            var lastVisible = list.children("li:visible:last");
            var next = lastVisible.nextAll("li:hidden").slice(0, 5);

            if (next.length < 5) {
                next = $.merge(next, list.children("li").slice(0, 5 - next.length));
                next.appendTo(list);
            }

            var prev = next.first().prevAll("li:visible");
            next.slideDown(200, "easeOutExpo");
            prev.slideUp(200, "easeOutExpo");
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library .menu div.h-folder .selectQuestions", function (event) {    
            var library = $(this).closest(".library");
            var folder = $(this).closest(".h-folder");
            libraryBrowser.loadFolderContent(folder, function () { SelectQuestions(folder); });
            event.stopPropagation(); 
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library .h-search", function (event) {
            libraryBrowser.searchItems($(this));
        });

        libraryBrowser.container.on("keypress", ".v-libraryBrowser .library .h-find, .h-findSurvey", function (event) {
            var keycode = (event.keyCode ? event.keyCode : event.which);

            if (keycode == 13)
                libraryBrowser.searchItems($(this));

            return keycode != 13;
        });
        
        libraryBrowser.container.on("focusin", ".v-libraryBrowser .library .h-find", function (event) {    
            $(this).addClass("active");
        });

        libraryBrowser.container.on("focusout", ".v-libraryBrowser .library .h-find", function (event) {
            $(this).removeClass("active");             
        });

        libraryBrowser.container.on("input", ".v-libraryBrowser .library .h-findSurvey", function (event) {
            libraryBrowser.resetActiveItems($(this).closest(".library"));
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library div.item", function (event) {    
            if (!$(this).hasClass("noPreview")) {
                libraryBrowser.loadQuestionPreview($(this));
            }
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library .menu div.item .actionButton", function (event) {    
            libraryBrowser.selectQuestion($(this).closest("div.item"));
            event.stopPropagation();
        });

        libraryBrowser.container.on("click", ".v-libraryBrowser .library .questions .addPreviewQuestion", function (event) {            
            if(libraryBrowser.itemInPreview) {
                libraryBrowser.selectQuestion(libraryBrowser.itemInPreview);
                event.stopPropagation();
            }
        });
    
        libraryBrowser.container.on("click", ".v-libraryBrowser .library .questions .selected div.item .actionButton", function (event) {    
            var question = $(this).closest("div.item");
            var library = question.closest(".library");
            question.detach();

            if($(".selected div.item", library).length == 0) {
                $(".selectedQuestions", library).hide();
            }

            event.stopPropagation();
        });
    },

    searchQuestionnaires: function (library, searchText)
    {
        libraryBrowser.resetActiveItems(library);

        var surveys = library.find(".questionnaires-list.v-sectionItems li");
        var items = [];

        library.find(".questionnaires-list.v-sectionItems").hide();

        var browser = library.closest(".v-libraryBrowser");
        var foundItemsList = $(".found-items-list", browser);

        $("ul.v-folderList.fixed", library).removeClass("fixed");

        var matcher = new RegExp($.ui.autocomplete.escapeRegex(searchText), "i");

        _.each(surveys, function (item) {
            if ($(item).data("survey-name") && matcher.test($(item).data("survey-name")))
                items.push($(item).clone());
        });

        if (items.length == 0) {
            items.push("<li><div class='item noPreview emptyItem'><div class='text'>" + richTextEditorResources.NoItemsFound + "</div></div></li>");
        }

        foundItemsList.html(items);

        // If found items list not in currently library then move library
        if ($(".found-items-list", library).length == 0) {
            foundItemsList.addClass("survey-found-items");
            $("ul.v-folderList:first", library).after(foundItemsList);
        }

        foundItemsList.show();
        libraryBrowser.addPager(foundItemsList);
    }
};